﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Art_of_War
{
    public class LevelEinstellungen
    {
        public List<Basis> basisliste;
        public int Basenzahl { get { return basisliste.Count; } }
        public koordinaten spielfeldgroesse;

        public event EventHandler<LevelEventArgs> levelsettingschanged;
        //private SettingsForm settingsForm;


        public LevelEinstellungen()
        {
            basisliste = new List<Basis>();
        }

        public LevelEinstellungen(LevelEinstellungen levelsettings)
        {
            this.basisliste = levelsettings.basisliste;
            this.spielfeldgroesse = levelsettings.spielfeldgroesse;
        }


        public LevelEinstellungen(koordinaten spielfeldgroesse)
        {
            basisliste = new List<Basis>();
            this.spielfeldgroesse = spielfeldgroesse;           
        }

        public LevelEinstellungen(SettingsForm settingsForm)
        {
            settingsForm.levelsettingschanged += new EventHandler<LevelEventArgs>(levelsettings_changed);
            //// TODO: Complete member initialization
            //this.settingsForm = settingsForm;
        }

        private void levelsettings_changed(object sender, LevelEventArgs e)
        {
            if (levelsettingschanged != null)
            {
                levelsettingschanged(this, e);
            }

        }


        public void AddBasis(Basis b)
        {
            basisliste.Add(b);
        }

    }
}
